% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_system.R
\name{createInSilicoSystem}
\alias{createInSilicoSystem}
\title{Creates an in silico system.}
\usage{
createInSilicoSystem(empty = F, ev = getJuliaEvaluator(), ...)
}
\arguments{
\item{empty}{Logical. Does the regulatory network is empty (= no regulation)? Default value is \code{FALSE}.}

\item{ev}{A Julia evaluator (for the XRJulia package). If none provided select the current evaluator or create one if no evaluator exists.}

\item{...}{Other arguments to be passed to the function \code{\link{insilicosystemargs}} (i.e. parameters for the generation of the in silico system).}
}
\value{
An object of class \code{insilicosystem}, that is a list composed of:
\itemize{
\item \code{genes}: a data-frame of genes (see \code{\link{createGenes}});
\item \code{edg}: a data-frame of edges in the regulatory network (see \code{\link{createMultiOmicNetwork}});
\item \code{mosystem}: a list defining the regulatory network (see \code{\link{createMultiOmicNetwork}});
\item \code{sysargs}: An object of class \code{insilicosystemargs}; the parameters used to create the system.
}
}
\description{
Creates an in silico system, i.e. the genes and the regulatory network defining the system.
}
\examples{
\donttest{
## Creates an in silico system composed of 20 genes
mysystem1 = createInSilicoSystem(G = 20)
mysystem1$edg ## see all regulations in the system
mysystem1$mosystem$TCRN_edg ## see only regulations targeting transcription

## Creates an in silico systerm composed of 10 genes, all protein-coding
mysystem2 = createInSilicoSystem(G = 10, PC.p = 1)
mysystem2$genes

## Creates an in silico systerm composed of 5 genes,
## all noncoding and all regulators of transcription
mysystem3 = createInSilicoSystem(G = 5, PC.p = 0, NC.TC.p = 1)
mysystem3$edg
mysystem3$mosystem$TCRN_edg
}
}
