% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{sortComponents}
\alias{sortComponents}
\title{Sort component names.}
\usage{
sortComponents(componames)
}
\arguments{
\item{componames}{A character vector, giving the names of the components.}
}
\value{
A dataframe: first column: sorted names of the components, second column: is the component a
regulatory complex?, third column: is the component a modified protein?
}
\description{
Sorts the names of the components of an in silico system (for plotting or summary).
}
\details{
Sort components into:
\itemize{
\item Genes (first) vs regulatory complexes
}
Then genes are sorted according to:
\itemize{
\item Gene ID (numeric)
\item Gene type (RNAs, then proteins, then modified proteins)
\item Allele
\item If the components don't have a type (e.g. see the legend resulting from \code{\link{plotSimulation}}),
non-modified vs modified
}
Then sort complexes according to:
\itemize{
\item Target reaction in the following order: regulators of transcription, translation, RNA decay,
protein decay, post-translational modification
\item Allele of their components
}
}
