% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_clustering.R
\name{hclust_haystack_raw}
\alias{hclust_haystack_raw}
\title{Function for hierarchical clustering of genes according to their distribution on a 2D plot.}
\usage{
hclust_haystack_raw(x, y, detection, genes, method = "ward.D")
}
\arguments{
\item{x}{x-axis coordinates of cells in a 2D representation (e.g. resulting from PCA or t-SNE)}

\item{y}{y-axis coordinates of cells in a 2D representation}

\item{detection}{A logical matrix showing which genes (rows) are detected in which cells (columns)}

\item{genes}{A set of genes (of the 'detection' data) which will be clustered.}

\item{method}{The method to use for hierarchical clustering. See '?hclust' for more information. Default: "ward.D".}
}
\value{
An object of class hclust, describing a hierarchical clustering tree.
}
\description{
Function for hierarchical clustering of genes according to their distribution on a 2D plot.
}
\examples{
# using the toy example of the singleCellHaystack package
# define a logical matrix with detection of each gene (rows) in each cell (columns)
dat.detection <- dat.expression > 1

# running haystack in default mode
res <- haystack(dat.tsne, detection=dat.detection, method = "2D")

# get biased genes, store in variable gene.subset
sorted.table <- show_result_haystack(res, p.value.threshold = 1e-5)
gene.subset <- row.names(sorted.table)

# hierarchical clustering, and cutting into 5 clusters
hc <- hclust_haystack(dat.tsne, detection=dat.detection, genes=gene.subset)
hc.clusters <- cutree(hc,k = 5)
}
