% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTD.R
\name{BTD}
\alias{BTD}
\title{Bayesian Test of Deficit}
\usage{
BTD(
  case,
  controls,
  sd = NULL,
  sample_size = NULL,
  alternative = c("less", "greater", "two.sided"),
  int_level = 0.95,
  iter = 10000,
  na.rm = FALSE
)
}
\arguments{
\item{case}{Case observation, can only be a single value.}

\item{controls}{Numeric vector of observations from the control sample. If
single value, treated as mean.}

\item{sd}{If input of controls is single value, the standard
deviation of the sample must be given as well.}

\item{sample_size}{If input of controls is single value, the size of the
sample must be given as well.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"less"} (default), \code{"greater"} or
\code{"two.sided"}. You can specify just the initial letter.}

\item{int_level}{Level of confidence for credible intervals, defaults to 95\%.}

\item{iter}{Number of iterations. Set to higher for more accuracy, set to
lower for faster calculations.}

\item{na.rm}{Remove \code{NA}s from controls.}
}
\value{
A list with class \code{"htest"} containing the following components:
\tabular{llll}{
\code{statistic}   \tab the mean z-value over \code{iter} number of
iterations \cr\cr  \code{parameter} \tab the degrees of freedom used to
specify the posterior distribution. \cr\cr \code{p.value}    \tab the mean p-value
for all simulated Z-scores.\cr\cr \code{estimate}    \tab estimated standardised difference
(Z-CC) and point estimate of p-value. \cr\cr \code{null.value}   \tab the
value of the difference under the null hypothesis.\cr\cr \code{interval}
\tab named numerical vector containing credibility level and intervals for
both Z-CC and estimated proportion. \cr\cr \code{desc}     \tab named
numerical containing descriptive statistics: mean and standard deviations of
controls as well as sample size. \cr\cr \code{alternative}     \tab a
character string describing the alternative hypothesis.\cr\cr \code{method}
\tab a character string indicating what type of test was performed.\cr\cr
\code{data.name} \tab a character string giving the name(s) of the data as
well as summaries. }
}
\description{
Takes a single observation and compares it to a distribution estimated by a
control sample using Bayesian methodology. Calculates standardised difference
between the case score and the mean of the controls and proportions falling
above or below the case score, as well as associated credible intervals. This
approach was developed by Crawford and Garthwaite (2007) but converge to the
results of \code{\link{TD}()}, which is faster. Returns the point estimate of
the standardised difference between the case score and the mean of the
controls and the point estimate of the p-value (i.e. the percentage of the
population that would be expected to obtain a lower or higher score,
depending on the alternative hypothesis). This test is based on random number
generation which means that results may vary between runs. This is by design
and the reason for not using \code{set.seed()} to reproduce results inside
the function is to emphasise the randomness of the test. To get more accurate
and stable results please increase the number of iterations by increasing
\code{iter} whenever feasible.
}
\examples{
BTD(case = -2, controls = 0, sd = 1, sample_size = 20, iter = 1000)

BTD(case = size_weight_illusion[1, "V_SWI"],
    controls = size_weight_illusion[-1, "V_SWI"], alternative = "l", iter = 1000)

}
\references{
Crawford, J. R., & Garthwaite, P. H. (2007). Comparison of a single case to a
control or normative sample in neuropsychology: Development of a Bayesian
approach. \emph{Cognitive Neuropsychology, 24}(4), 343–372.
https://doi.org/10.1080/02643290701290146
}
