% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-class.R
\docType{class}
\name{Output-class}
\alias{Output-class}
\title{An S4 class representing the output of a method run by simulator.}
\description{
An object of class \code{Output} consists of information to identify the
model, draws, and method objects this output was derived from.  It also has
a list called \code{out}, which is where the output of the method is stored.
}
\section{Slots}{

\describe{
\item{\code{model_name}}{the name of the \code{\linkS4class{Model}} object this output is
derived from.}

\item{\code{index}}{the index of the \code{\linkS4class{Draws}} object this output is
derived from.}

\item{\code{method_name}}{the name of the \code{\linkS4class{Method}} object this output is
derived from.}

\item{\code{method_label}}{the label of the \code{\linkS4class{Method}} object this output
is derived from.}

\item{\code{out}}{a named list with each element labeled as \code{ri.j} where
\code{i} is the \code{index} and \code{j} ranges from \code{1} to
\code{nsim}.  Element \code{out$ri.j} is output of method
\code{method_name} on random draw \code{ri.j}.}
}}

