% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeOutliers.R
\name{removeOutliers}
\alias{removeOutliers}
\title{Remove data outliers}
\usage{
removeOutliers(x, k = 1.5)
}
\arguments{
\item{x}{vector of data.}

\item{k}{factor to applied to the interquartile range (default = 1.5).}
}
\value{
A numeric vector with the same length as input vector.
}
\description{
Remove data outliers based on the interquartile range.
}
\details{
The interquartile range IQR is computed from input dataset as IQR = Q3 - Q1,
where Q1 is 25th percentile and Q3 is the 75th percentile.
Values larger than Q3 + k * IQR and smaller than Q1 - k * IQR are deemed
as outliers and substituted with NA's.

The default value of k is 1.5.
}
\examples{
mydata <- c(-10 * runif(10), runif(10))
removeOutliers(mydata)

}
