% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilityClass.R
\name{stabilityClass}
\alias{stabilityClass}
\title{Stability class.}
\usage{
stabilityClass(rad, tcc, ws, option = "impact")
}
\arguments{
\item{rad}{The net radiation in W/m^2}

\item{tcc}{The total cloud cover in a range from 1  to 8}

\item{ws}{wind speed in m/s}

\item{option}{This is to determine which specific categories to use
to determine the stability
class. It can be \code{impact} to comply with ARIA Impact(tm),
\code{pasquill} or \code{custom}.}
}
\value{
\code{stabilityClass} returns a vector with stability Pasquill
stability class as: A = 1, ... , F = 6.
}
\description{
\code{stabilityClass} computes stability class.
}
\details{
It computes stability class according to IAEA method based on net radiation
and wind.
Net radiation and wind are used by day; tcc and wind are used by night.
}
\examples{
\dontrun{
# Compute Pasquill stability class
mydata$sc <- stabilityClass(mydata$rad, mydata$tcc, mydata$ws, option="pasquill")
}
}
