% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_arma11}
\alias{gen_arma11}
\title{Generate an ARMA(1,1) sequence}
\usage{
gen_arma11(N, phi = 0.1, theta = 0.3, sigma2 = 1)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{phi}{A \code{double} that contains autoregressive.}

\item{theta}{A \code{double} that contains moving average.}

\item{sigma2}{A \code{double} that contains process variance.}
}
\value{
A \code{vec} containing the MA(1) process.
}
\description{
Generate an ARMA(1,1) sequence given \eqn{\phi}, \eqn{\theta}, and \eqn{\sigma^2}.
}
\details{
The function implements a way to generate the \eqn{x_t}{x[t]} values without calling the general ARMA function.
}
\section{Process Definition}{

The Autoregressive order 1 and Moving Average order 1 (ARMA(1,1)) process with non-zero parameters \eqn{\phi \in (-1,+1)}{phi in (-1,1)} for the AR component,
 \eqn{\theta \in (-1,+1)}{theta in (-1,+1)} for the MA component, and \eqn{\sigma^2 \in {\rm I\!R}^{+}}{sigma^2 in R^{+}}.
This process is defined as:
 \deqn{{X_t} = {\phi _1}{X_{t - 1}} + {\theta _1}{\varepsilon_{t - 1}} + {\varepsilon_t}}{W[t] = phi*W[t-1] + theta*W[t-1] + W[t]},
 where
  \deqn{{\varepsilon_t}\mathop  \sim \limits^{iid} N\left( {0,\sigma^2} \right)}{W[t] ~ N(0,sigma^2) iid}
}

\section{Generation Algorithm}{

The function first generates a vector of white noise using \code{gen_wn} and then obtains the
ARMA values under the above equation.

The \eqn{X_0}{X[0]} (first value of \eqn{X_t}{X[t]}) is discarded.
}

\keyword{internal}
