% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defReadCond.R
\name{defReadCond}
\alias{defReadCond}
\title{Read external csv data set definitions for adding columns}
\usage{
defReadCond(filen)
}
\arguments{
\item{filen}{String file name, including full path. Must be a csv file.}
}
\value{
A data.table with data set definitions
}
\description{
Read external csv data set definitions for adding columns
}
\examples{
# Create temporary external "csv" files

test1 <- c("varname,formula,variance,dist,link",
           "x,0.3;0.4;0.3,0,categorical,identity"
          )

tfcsv1 <- tempfile()
writeLines(test1, tfcsv1)

test2 <- c("condition,formula,variance,dist,link",
           "x == 1, 0.4,0,binary,identity",
           "x == 2, 0.6,0,binary,identity",
           "x >= 3, 0.8,0,binary,identity"
          )

tfcsv2 <- tempfile()
writeLines(test2, tfcsv2)

# Generate data based on external definitions

defs <- defRead(tfcsv1)
dt <- genData(2000, defs)
dt

# Add column based on

defsCond <- defReadCond(tfcsv2)
dt <- addCondition(defsCond, dt, "y")
dt

dt[, mean(y), keyby = x]

unlink(tfcsv1)
unlink(tfcsv2)
}
