% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paircormin.R
\name{paircormin}
\alias{paircormin}
\title{Minimize Pairwise Correlation}
\usage{
paircormin(Design, kvec, ti = 10, tf = 0.0001, alph = 0.99, iter = 2000)
}
\arguments{
\item{Design}{The unoptimized design}

\item{kvec}{A vector containing the number of columns in each block of the design}

\item{ti}{Initial temperature value for SA}

\item{tf}{Final temperature value for SA}

\item{alph}{Decay parameter for SA (should be less than 1)}

\item{iter}{Number of iterations at each temperature value, should increase with design size}
}
\value{
\describe{
\item{Design}{The design optimized to minimize pairwise correlations between input classes.}
\item{CritVals}{The pairwise correlations at each temperature change, useful for checking if the SA algorithm has converged.}
}
}
\description{
Optimizes run order within classes of homogeneous agents to minimize pairwise correlation using Simulated Annealing.
}
\details{
This function optimizes run order within each block of a design made of multiple simplexes to minimize pairwise correlations using a Simulated Annealing algorithm.  The criterion of interest is the sum of squared cor(\eqn{xi},\eqn{xj}) for all pairs of columns between classes.  It is recommended that the parameters (such as ti, tf, and iter) are scaled with the size of the design size, and that the criterion values should settle to some local optimal value.
}
\examples{

# Generate Unoptimized Design
D1 <- MmSimplex(3,30,10,cords = 1,randst = 1,phival = 50)
D2 <- MmSimplex(3,30,10,cords = 1,randst = 1,phival = 50)
D3 <- MmSimplex(3,30,10,cords = 1,randst = 1,phival = 50)
D <- cbind(D1[[1]],D2[[1]],D3[[1]])
c1 <- sum(cor(D1[[1]])[upper.tri(cor(D1[[1]]))]^2)
c2 <- sum(cor(D2[[1]])[upper.tri(cor(D2[[1]]))]^2)
c3 <- sum(cor(D3[[1]])[upper.tri(cor(D3[[1]]))]^2)
## Sum all pariwise correlations and
sum(cor(D)[upper.tri(cor(D))]^2) - (c1 + c2 + c3)
## Optimize run order
Dopt <- paircormin(D, c(3,3,3), ti = 0.01, tf = 0.0005, iter = 25)
sum(cor(Dopt[[1]])[upper.tri(cor(Dopt[[1]]))]^2) - (c1 + c2 + c3)


}
