% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_boxplot.R
\name{summarise_boxplot_outliers}
\alias{summarise_boxplot_outliers}
\title{Summarise outliers in a dataset or tibble.}
\usage{
summarise_boxplot_outliers(data, var, ...)
}
\arguments{
\item{data}{A data frame. Required input. Group the dataset as appropriate prior.}

\item{var}{Unquoted variable from which to calculate outliers. Required input.}

\item{...}{Passed to \code{boxplot.stats}}
}
\value{
A data frame.
}
\description{
Summarise outliers in a dataset or tibble.
}
\examples{
library(simplevis)
library(dplyr)
library(palmerpenguins)

penguins \%>\% 
  group_by(species) \%>\% 
  summarise_boxplot_outliers(body_mass_g)

}
