% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_hpointrange.R
\name{gg_hpointrange}
\alias{gg_hpointrange}
\title{Horizontal pointrange ggplot.}
\usage{
gg_hpointrange(
  data,
  x_var,
  xmin_var,
  xmax_var,
  y_var,
  text_var = NULL,
  pal = pal_viridis_reorder(1),
  alpha_line = 1,
  alpha_point = 1,
  size_point = 1.5,
  size_line = 0.5,
  title = NULL,
  title_wrap = 75,
  subtitle = NULL,
  subtitle_wrap = 75,
  x_balance = FALSE,
  x_breaks_n = 5,
  x_expand = c(0, 0),
  x_labels = scales::label_comma(),
  x_na_rm = FALSE,
  x_title = "",
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_balance = FALSE,
  y_breaks_n = 5,
  y_expand = NULL,
  y_labels = NULL,
  y_na_rm = FALSE,
  y_rev = FALSE,
  y_title = NULL,
  y_title_wrap = 50,
  y_zero = FALSE,
  y_zero_line = NULL,
  caption = NULL,
  caption_wrap = 75,
  theme = gg_theme(gridlines = "vertical"),
  mobile = FALSE
)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe in a structure to be plotted untransformed. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{xmin_var}{Unquoted numeric variable to be the minimum of the x vertical line. Required input.}

\item{xmax_var}{Unquoted numeric variable to be the maximum of the x vertical line. Required input.}

\item{y_var}{Unquoted variable to be on the y scale (i.e. character, factor, logical, numeric, date or datetime). If numeric, date or datetime, variable values are bins that are mutually exclusive and equidistant. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{pal}{Character vector of hex codes.}

\item{alpha_line}{The opacity of the line. Defaults to 1.}

\item{alpha_point}{The opacity of the points.}

\item{size_point}{Size of points. Defaults to 1.5.}

\item{size_line}{Size of lines. Defaults to 0.75.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 60.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 60.}

\item{x_balance}{For a numeric x variable, add balance to the x scale so that zero is in the centre of the x scale.}

\item{x_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. Use function(x) x to keep labels untransformed.}

\item{x_na_rm}{TRUE or FALSE of whether to include x_var NA values. Defaults to FALSE.}

\item{x_title}{X scale title string. Defaults to "".}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_balance}{For a numeric y variable, add balance to the y scale so that zero is in the centre. Defaults to FALSE.}

\item{y_breaks_n}{For a numeric or date y variable, the desired number of intervals on the y scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. If NULL, categorical variable labels are converted to sentence case. Use function(x) x to keep labels untransformed.}

\item{y_na_rm}{TRUE or FALSE of whether to include y_var NA values. Defaults to FALSE.}

\item{y_rev}{For a categorical variable, TRUE or FALSE of whether the y variable variable is reversed. Defaults to FALSE.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_zero}{For a numeric y variable, TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to FALSE.}

\item{y_zero_line}{For a numeric y variable, TRUE or FALSE of whether to add a zero reference line to the y scale. Defaults to TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 75.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Horizontal pointrange ggplot that is not coloured and not facetted.
}
\examples{
library(dplyr)
library(simplevis)
library(palmerpenguins)

plot_data <- penguins \%>\%
  group_by(sex) \%>\%
  summarise(middle = median(body_mass_g, na.rm = TRUE),
            lower = quantile(body_mass_g, probs = 0.25, na.rm = TRUE),
            upper = quantile(body_mass_g, probs = 0.75, na.rm = TRUE))

gg_hpointrange(
  plot_data,
  x_var = middle,
  xmin_var = lower,
  xmax_var = upper,
  y_var = sex,
  x_title = "Body mass g", 
  y_na_rm = TRUE)
  
}
