% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_stars_fun.R
\name{ggplot_stars_facet}
\alias{ggplot_stars_facet}
\title{Map of an array in ggplot that is facetted.}
\usage{
ggplot_stars_facet(data, pal = NULL, facet_nrow = NULL,
  title = "[Title]", subtitle = NULL, caption = NULL,
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, title_wrap = 70, subtitle_wrap = 80,
  caption_wrap = 80)
}
\arguments{
\item{data}{A stars object with 2 dimensions, x and y, and multiple named attribute layers with usual convention of lower case and underscores. These attribute layers will be facetted. Required input.}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is facetted, but not coloured.
}
\examples{
map_data1 <- example_stars \%>\%
  rlang::set_names("Variable A")

map_data2 <- example_stars_2 \%>\%
  rlang::set_names("Variable B")

map_data <- c(map_data1, map_data2)

ggplot_stars_facet(data = map_data)
}
