\name{getNetwork}
\alias{getNetwork}

\title{Network extraction from a SIMoNe run}

\description{When running \code{simone}, a family of networks is
  generated and one may want to pick one of them according to a given
  criterion. This is the job handled by the \code{getNetwork} function.}

\usage{%
getNetwork(object,
           selection = length(object$clusters),
           nodes     = NULL)}

\arguments{
  \item{object}{%
    output of a SIMoNe run (must be an object of class  \code{simone})
  }
  \item{selection}{%
    either a character string (\code{"BIC"} or \code{"AIC"}) or an
    integer (a number of edges) that specifies how the network is selected
    from the list generated by \code{simone}. When a number \code{num} of
    edges is specified, the network is extracted by picking from the list
    the network with at most \code{num} edges. The effective number
    \code{num} will be displayed. Default is to extract a number of edges
    at most equal to the number of variables.
  }
  \item{nodes}{%
    a vector of character string or integers used to extract a
    sub-part of the selected network, which can be more readable. When
  \code{NULL} (the default), all the variables are kept.
  }
}

\value{
  Returns an object of class \code{simone.network}, see \code{rNetwork} for
  further details.
}

\author{J. Chiquet}

\seealso{
  \code{\link{simone}}, \code{\link{rNetwork}}, \code{\link{plot.simone.network}}.
}
\examples{
## load the breast cancer data set
data(cancer)
attach(cancer)

## launch SIMoNe on the full data set
res <- simone(expr)

## the default selected network (at most p edges)
plot(getNetwork(res))

## a sub network on some 10 randomly selected genes
plot(getNetwork(res,"BIC", nodes = sample(colnames(expr),10)))

## a network with a penalty corresponding to at most 40 edges
plot(getNetwork(res, 40))

detach(cancer)
}

\keyword{graphs}
