% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simode.R
\name{plot_trace}
\alias{plot_trace}
\title{Plot optimization trace of a call to \code{simode}}
\usage{
plot_trace(x, show = c("nls", "im", "both"), which = NULL,
  mfrow = par("mfrow"), cols = list(nls_fit = "blue", im_fit = "green"),
  ...)
}
\arguments{
\item{x}{\code{simode} object returned by a call to \code{\link{simode}}.}

\item{show}{Whether to plot the estimates obtained
using nonlinear least squares ('nls'), integral-matching ('im') or both ('both').}

\item{which}{Which parameters' traces to plot. If NULL, the
trace for all the parameters in \code{x} will be plotted.}

\item{mfrow}{A vector of the form c(nr,nc) setting the layout of
subplots in one plot (see also \code{\link{par}}).}

\item{cols}{List of colors for each element of the plot.}

\item{...}{Additional argument(s) for methods.}
}
\description{
Plot a trace of the loss values and parameter estimates during
the integral-matching/nonlinear least squares optimization within a call to \code{simode}.
For the traces to exist, the arguments \code{save_im_trace} and/or
\code{save_nls_trace} in \code{\link{simode.control}} should be set to true,
when calling \code{simode}.
}
