% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_reg_func.r
\name{sim_reg_nested3}
\alias{sim_reg_nested3}
\title{Function to simulate three level nested data}
\usage{
sim_reg_nested3(fixed, random, random3, fixed_param,
  random_param = list(), random_param3 = list(), cov_param, k, n, p,
  error_var, with_err_gen, arima = FALSE, data_str, cor_vars = NULL,
  fact_vars = list(NULL), unbal = list(level2 = FALSE, level3 = FALSE),
  unbal_design = list(level2 = NULL, level3 = NULL),
  lvl1_err_params = NULL, arima_mod = list(NULL), contrasts = NULL,
  homogeneity = TRUE, heterogeneity_var = NULL,
  cross_class_params = NULL, knot_args = list(NULL), ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation. 
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{random3}{One sided formula for random effects at third level in the 
simulation. Must be a subset of fixed (and likely of random).}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights). 
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var: variance of random parameters,
   \item  rand_gen: Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{random_param3}{A list of named elements that must contain: 
\itemize{
    \item random_var = variance of random parameters,
    \item rand_gen = Name of simulation function for random effects.
}
      Optional elements are:
\itemize{
    \item ther: Theorectial mean and variance from rand_gen,
    \item ther_sim: Simulate mean/variance for standardization purposes,
    \item cor_vars: Correlation between random effects,
    \item ...: Additional parameters needed for rand_gen function.
}}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    'level1', 'level2', or 'level3'. 
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{k}{Number of third level clusters.}

\item{n}{Level two cluster sample size within each level three cluster.}

\item{p}{Within cluster sample size within each level two cluster.}

\item{error_var}{Scalar of error variance.}

\item{with_err_gen}{Simulated within cluster error distribution. 
Must be a quoted 'r' distribution function.}

\item{arima}{TRUE/FALSE flag indicating whether residuals should 
be correlated. If TRUE, must specify a valid model to pass to 
arima.sim via the arima_mod argument. 
See \code{\link{arima.sim}} for examples.}

\item{data_str}{Type of data. Must be "cross" or "long".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'level1', 'level2', or 'level3'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A named TRUE/FALSE list specifying whether unbalanced simulation 
design is desired. The named elements must be: "level2" or "level3" representing
unbalanced simulation for level two and three respectively. Default is FALSE,
indicating balanced sample sizes at both levels.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the actual sample sizes within each cluster
can be specified. This takes the form of a vector that must have the same length 
as the level two or three sample size. These are specified as a named list in which
level two sample size is controlled via "level2" and level three sample size is 
controlled via "level3".}

\item{lvl1_err_params}{Additional parameters passed as a list on to the 
level one error generating function}

\item{arima_mod}{A list indicating the ARIMA model to pass to arima.sim. 
See \code{\link{arima.sim}} for examples.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{homogeneity}{Either TRUE (default) indicating homogeneity of variance
assumption is assumed or FALSE to indicate desire to generate heterogeneity 
of variance.}

\item{heterogeneity_var}{Variable name as a character string to use for 
heterogeneity of variance simulation.}

\item{cross_class_params}{A list of named parameters when cross classified 
data structures are desired. Must include the following arguments:
 \itemize{
  \item num_ids: The number of cross classified clusters. These are in 
       addition to the typical cluster ids
  \item random_param: This argument is a list of arguments passed to 
     \code{\link{sim_rand_eff}}. These must include:
    \itemize{
     \item random_var: The variance of the cross classified random effect
     \item rand_gen: The random generating function used to generate the 
        cross classified random effect.
    }
    Optional elements are:
  \itemize{
      \item ther: Theorectial mean and variance from rand_gen,
      \item ther_sim: Simulate mean/variance for standardization purposes,
      \item cor_vars: Correlation between random effects,
      \item ...: Additional parameters needed for rand_gen function.
  } 
 }}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}

\item{...}{Not currently used.}
}
\description{
Takes simulation parameters as inputs and returns simulated data.
}
\details{
Simulates data for the linear mixed model, both cross sectional and 
longitudinal data. Returns a data frame with ID variables, fixed effects, 
and many other variables useful to help when running simulation studies.
}
\examples{
#' # Three level example
fixed <- ~1 + time + diff + act + actClust + time:act
random <- ~1 + time + diff
random3 <- ~ 1 + time
fixed_param <- c(4, 2, 6, 2.3, 7, 0)
random_param <- list(random_var = c(7, 4, 2), rand_gen = 'rnorm')
random_param3 <- list(random_var = c(4, 2), rand_gen = 'rnorm')
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'), 
     var_type = c("level1", "level2", "level3"),
     opts = list(list(mean = 0, sd = 1.5),
     list(mean = 0, sd = 4),
     list(mean = 0, sd = 2)))
k <- 10
n <- 15
p <- 10
error_var <- 4
with_err_gen <- 'rnorm'
data_str <- "long"
temp_three <- sim_reg(fixed, random, random3, fixed_param, random_param, 
   random_param3, cov_param, k,n, p, error_var, with_err_gen, 
   data_str = data_str)

}
\seealso{
\code{\link{sim_reg}} for a convenient wrapper for all data 
 conditions.
}
