% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.Pheno}
\alias{simer.Data.Pheno}
\title{Phenotype data quality control}
\usage{
simer.Data.Pheno(
  filePhe = NULL,
  filePed = NULL,
  out = NULL,
  planPhe = NULL,
  pheCols = NULL,
  header = TRUE,
  sep = "\\t",
  missing = c(NA, "NA", "Na", ".", "-", "NAN", "nan", "na", "N/A", "n/a", "<NA>", "",
    "-9", 9999),
  verbose = TRUE
)
}
\arguments{
\item{filePhe}{the phenotype files, it can be a vector.}

\item{filePed}{the pedigree files, it can be a vector.}

\item{out}{the prefix of output file.}

\item{planPhe}{the plans for phenotype quality control.}

\item{pheCols}{the column needing extracting.}

\item{header}{the header of file.}

\item{sep}{the separator of file.}

\item{missing}{the missing value.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns files
\describe{
\item{<out>.phe}{the phenotype file after correction.}
}
}
\description{
Data quality control for phenotype data.
}
\details{
Build date: June 13, 2021
Last update: Apr 28, 2022
}
\examples{
# Get the filename of phenotype data
filePhe <- system.file("extdata", "05others", "phenotype.txt", package = "simer")

# Run phenotype correction
simer.Data.Pheno(filePhe = filePhe, out = tempfile("outfile"))
}
\author{
Haohao Zhang and Dong Yin
}
