% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-ssm-cov-eta.R
\name{SSMCovEta}
\alias{SSMCovEta}
\title{Steady-State Covariance Matrix for the
Latent Variables in the
State Space Model}
\usage{
SSMCovEta(beta, psi)
}
\arguments{
\item{beta}{Numeric matrix.
Transition matrix relating the values of the latent variables
at the previous to the current time point
(\eqn{\boldsymbol{\beta}}).}

\item{psi}{Numeric matrix.
The covariance matrix
of the process noise
(\eqn{\boldsymbol{\Psi}}).}
}
\description{
The steady-state covariance matrix
for the latent variables
in the state space model
\eqn{\mathrm{Cov} \left( \boldsymbol{\eta} \right)}
is given by
\deqn{
  \mathrm{vec}
  \left(
    \mathrm{Cov} \left( \boldsymbol{\eta} \right)
  \right)
  =
  \left(
    \mathbf{I} - \boldsymbol{\beta} \otimes \boldsymbol{\beta}
  \right)^{-1}
  \mathrm{vec} \left( \boldsymbol{\Psi} \right)
}
where
\eqn{\boldsymbol{\beta}}
is the transition matrix relating the values of the latent variables
at the previous to the current time point
and
\eqn{\boldsymbol{\Psi}}
is the covariance matrix
of volatility or randomness in the process.
}
\examples{
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0.0, 0.0, 0.5
  ),
  nrow = 3
)
psi <- 0.1 * diag(3)
SSMCovEta(
  beta = beta,
  psi = psi
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
