% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SpectralRadius}
\alias{SpectralRadius}
\title{Spectral Radius}
\usage{
SpectralRadius(x)
}
\arguments{
\item{x}{Numeric square matrix.}
}
\value{
Numeric value representing the spectral radius of \code{x}.
}
\description{
Computes the spectral radius of a square matrix,
defined as the maximum modulus (absolute value) of its eigenvalues.
The spectral radius is often used to assess the stability of systems
such as vector autoregressive (VAR) models:
a system is considered stationary
if the spectral radius of its transition matrix is strictly less than 1.
}
\examples{
# Matrix with eigenvalues less than 1
x <- matrix(
  data = c(
    0.5, 0.3,
    0.2, 0.4
  ),
  nrow = 2
)
SpectralRadius(x)

# Matrix with eigenvalues greater than 1
y <- matrix(
  data = c(
    1.2, 0.3,
    0.4, 0.9
  ),
  nrow = 2
)
SpectralRadius(y)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
\keyword{stability}
