% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SpectralAbscissa}
\alias{SpectralAbscissa}
\title{Spectral Abscissa}
\usage{
SpectralAbscissa(x)
}
\arguments{
\item{x}{Numeric square matrix.}
}
\value{
Numeric value \eqn{\alpha(x) = \max \Re(\lambda_i(x))}.
}
\description{
Returns the maximum real part of the eigenvalues of a square matrix.
For continuous-time stability (Hurwitz),
a matrix is stable if the spectral abscissa is strictly less than 0.
}
\examples{
# Hurwitz-stable (spectral abscissa < 0):
x <- matrix(
  data = c(
    -0.5, -0.2,
     1.0, -0.3
  ),
  nrow = 2
)
SpectralAbscissa(x = x) # < 0

# Unstable (spectral abscissa > 0):
x <- matrix(
  data = c(
     0.10, 0.50,
    -0.40, 0.20
  ),
  nrow = 2
)
SpectralAbscissa(x = x) # > 0

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{stability}
