% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSimulatedData.R
\name{getOneToTwoRows}
\alias{getOneToTwoRows}
\title{Transitions from the Intermediate State to the Absorbing State}
\usage{
getOneToTwoRows(simDataOne, transition)
}
\arguments{
\item{simDataOne}{(\code{data.frame})\cr a data frame containing all patients with transitions
into the intermediate state. See \code{\link[=getSimulatedData]{getSimulatedData()}} for details.}

\item{transition}{(\code{TransitionParameters})\cr transition parameters comprising
\code{hazards}, corresponding \code{intervals} and \code{weibull_rates}, see \code{\link[=exponential_transition]{exponential_transition()}}, \code{\link[=piecewise_exponential]{piecewise_exponential()}}
and \code{\link[=weibull_transition]{weibull_transition()}} for details.}
}
\value{
This returns a data frame with one row per patient for the second transition,
i.e. the transition out of the intermediate
state. This is a helper function of \code{\link[=getSimulatedData]{getSimulatedData()}}.
}
\description{
This function creates transition entry and exit times from the intermediate state to the absorbing state
for an existing data frame containing the exit times out of the initial state.
}
\examples{
simDataOne <- data.frame(
  id = c(1:3), to = c(1, 1, 1), from = c(0, 0, 0), entry = c(0, 0, 0),
  exit = c(3, 5.6, 7.2), censTime = c(6.8, 5.9, 9.4)
)
transition <- exponential_transition(1, 1.6, 0.3)
getOneToTwoRows(simDataOne, transition)
}
