% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewiseDistribution.R
\name{PCWInversionMethod}
\alias{PCWInversionMethod}
\title{Single Piecewise Exponentially Distributed Event Time}
\usage{
PCWInversionMethod(haz, pw, LogU)
}
\arguments{
\item{haz}{(\code{numeric})\cr piecewise constant hazard.}

\item{pw}{(\code{numeric})\cr time intervals for the piecewise constant hazard.}

\item{LogU}{(\code{numeric})\cr transformed uniformly distributed random variables (log(1-U)).}
}
\value{
This returns one single event time.
}
\description{
This returns an event time with a distribution resulting from piece-wise constant hazards
using the inversion method.
}
\examples{
PCWInversionMethod(haz = c(1.1, 0.5, 0.4), pw = c(0, 7, 10), LogU = log(1 - runif(1)))
}
