% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbors_by_dist.R
\name{neighbors_by_dist}
\alias{neighbors_by_dist}
\title{Determine and store neighbors by Euclidean Distance Constraints}
\usage{
neighbors_by_dist(x, y, coords, im.res, r, print.ring = FALSE)
}
\arguments{
\item{x, y}{are the row and column coordinates, respectively.}

\item{coords}{A dataframe containing indices and coordinates for the image.}

\item{im.res}{A vector containing the number of rows and columns, respectively.}

\item{r}{A scalar value determining the radius within which other locations
are neighbors to the current location (x, y).}

\item{print.ring}{When \code{print.ring = TRUE}, each iteration is shown,
with corresponding information regarding the number of neighbors present
in each ring. This argument primarily exists to allow the user to test
whether the neighborhood structure specified is as desired.}
}
\value{
A tibble whose first column contains x indices, second column contains y indices, and
third column denotes the current ring about a location.
}
\description{
Determine and store neighbors by Euclidean Distance Constraints
}
\note{
This function avoids testing all points for being with a certain distance
 in order to determine neighbor status of a given point by progressively widening
 a box around the point. Each iteration widens the box by an extra ring, and we
 only test points in the new ring. If at the end of testing a ring there are no
 new neighbors then we stop expanding the box and return the neighbors' coordinates.
 For computational efficiency, this function assumes that all arguments except the
 current point's coordinates have been specified.
}
\examples{
## Necessary pre-specified arguments required for the function to work.

## requires tidyverse (dplyr)
library(tidyverse)

## image resoluation + number of spatial predictors
im.res <- c(5, 5)
J = prod(im.res)

## create predictor indices w/ coordinates
row.id <-rep(1, im.res[2])
for (i in 2:im.res[1]) {
 row.id <- c(row.id, rep(i, im.res[2]))
}
coords <- data.frame(index = 1:J,
                     row.id = row.id,
                     col.id = rep(c(1:im.res[2]), im.res[1]) )

neighbors_by_dist(x = 2, y = 2, im.res = im.res, coords = coords, r = 2)

}
