% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{loadSimulation}
\alias{loadSimulation}
\title{Load some previously saved simulation data by function saveSimulation}
\usage{
loadSimulation(id)
}
\arguments{
\item{id}{Name the simulation to load which was previously saved by saveSimulation}
}
\description{
Load some previously saved simulation data by function saveSimulation
}
\examples{


examples_dir = system.file("examples", package = "sim1000G")
vcf_file = file.path(examples_dir, "region.vcf.gz")

vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
           min_maf = 0.12 ,max_maf = NA)

# For a realistic genetic map
# use the function readGeneticMap
generateUniformGeneticMap()

startSimulation(vcf, totalNumberOfIndividuals = 200)

ped1 = newNuclearFamily(1)

saveSimulation("sim1")

vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
               min_maf = 0.02 ,max_maf = 0.5)

startSimulation(vcf, totalNumberOfIndividuals = 200)
saveSimulation("sim2")

loadSimulation("sim1")



}
