% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf.R
\name{read_vcf}
\alias{read_vcf}
\title{Read VCF Files as MAF Object}
\usage{
read_vcf(
  vcfs,
  samples = NULL,
  genome_build = c("hg19", "hg38", "mm10"),
  keep_only_pass = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{vcfs}{VCF file paths.}

\item{samples}{sample names for VCF files.}

\item{genome_build}{genome build version like "hg19".}

\item{keep_only_pass}{if \code{TRUE}, keep only 'PASS' mutation for analysis.}

\item{verbose}{if \code{TRUE}, print extra info.}
}
\value{
a \link{MAF}.
}
\description{
MAF file is more recommended. In this function, we will mimic
the MAF object from the key \code{c(1, 2, 4, 5, 7)} columns of VCF file.
}
\examples{
vcfs <- list.files(system.file("extdata", package = "sigminer"), "*.vcf", full.names = TRUE)
\donttest{
maf <- read_vcf(vcfs)
maf <- read_vcf(vcfs, keep_only_pass = TRUE)
}
}
\seealso{
\link{read_maf}, \link{read_copynumber}
}
