% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineFitFunctions.R
\name{lineFitFunction}
\alias{lineFitFunction}
\title{Linear fit function.}
\usage{
lineFitFunction(dataInput, tryCounter, startList = list(slope = 0,
  intersection = 1), lowerBounds = c(-100, -1000), upperBounds = c(100,
  1000), min_Factor = 1/2^20, n_iterations = 500)
}
\arguments{
\item{dataInput}{a data frame composed of two columns. One is for time other is for intensity. Should be normalized data generated by normalizeData.}

\item{tryCounter}{the number of times the data is fit via maximum likelihood.}

\item{startList}{the initial set of parameters that the fitting algorithm tries, these parameters are the slope and the y intercept.}

\item{lowerBounds}{the lower bounds for the randomly generated start parameters, these parameters are the slope and the y intercept.}

\item{upperBounds}{the upper bounds for the randomly generated start parameters, these parameters are the slope and the y intercept.}

\item{min_Factor}{minimum step size used by the fitting algorithm.}

\item{n_iterations}{maximum number of iterations used by the fitting algorithm.}
}
\value{
Returns fitted parameters for lineFit. The slope, intersection, and goodness of fit metrics.
}
\description{
Fits a linear model to a given data by using likelihood maximization (LM) and gives the parameters (slope and intersection) describing the line as output. It also provides information about the goodness of fit such as AIC, BIC values, residual sum of squares, and log likelihood.
}
\examples{
time=seq(3,24,0.5)

#intensity with Noise
noise_parameter=.2
intensity_noise=stats::runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=lineFitFormula(time, slope=4, intersection=-2)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput)
parameterVector<-lineFitFunction(normalizedInput,tryCounter=2)

#Check the results
if(parameterVector$isThisaFit){
 intensityTheoretical=lineFitFormula(time,
                                     slope=parameterVector$slope_Estimate,
                                     intersection=parameterVector$intersection_Estimate)

 comparisonData=cbind(dataInput,intensityTheoretical)

 print(parameterVector$residual_Sum_of_Squares)

 require(ggplot2)
 ggplot(comparisonData)+
   geom_point(aes(x=time, y=intensity))+
   geom_line(aes(x=time,y=intensityTheoretical))+
   expand_limits(x = 0, y = 0)}

if(!parameterVector$isThisaFit){print(parameterVector)}
}

