% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{sv_optional}
\alias{sv_optional}
\title{Indicate that a field is optional}
\usage{
sv_optional(test = input_provided)
}
\arguments{
\item{test}{A single-argument function, or single-sided formula (using \code{.} to
access the value to test), that returns \code{TRUE} for success and \code{FALSE} for
failure.}
}
\value{
A function suitable for use as an
\code{\link[=InputValidator]{InputValidator$add_rule()}} rule.
}
\description{
Call \code{sv_optional()} to generate a validation function that indicates an
input is allowed to \emph{not} be present. If an \code{sv_optional()} rule sees that an
input is not present, subsequent rules for that input are skipped and the
input is considered valid. Otherwise, the rule simply passes.
(\code{sv_optional()} will never return a validation error/message.)

By default, the definition of "is present" is based on \code{\link[=input_provided]{input_provided()}}.

Child validators (see \code{\link[=InputValidator]{InputValidator$add_validator()}}) are
not affected by \code{sv_optional()} rules in parent validators; only rules in the
same validator instance as the \code{sv_optional()} will be skipped.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinyvalidate)

ui <- fluidPage(
  textInput("email", "Email")
)

server <- function(input, output, session) {
  
  # Validation rules are set in the server, start by
  # making a new instance of an `InputValidator()`
  iv <- InputValidator$new()

  # Basic usage: `sv_optional()` is often paired with
  # another `sv_*()` function; below, an email in
  # `input$email` is not required, but if present, it
  # must be valid
  iv$add_rule("email", sv_optional())
  iv$add_rule("email", sv_email())

  # Finally, `enable()` the validation rules
  iv$enable()
}

shinyApp(ui, server)

}

}
\seealso{
The \code{\link[=sv_required]{sv_required()}} function, which takes a different approach to
field presence.

Other rule functions: 
\code{\link{compose_rules}()},
\code{\link{sv_between}()},
\code{\link{sv_email}()},
\code{\link{sv_equal}()},
\code{\link{sv_gte}()},
\code{\link{sv_gt}()},
\code{\link{sv_in_set}()},
\code{\link{sv_integer}()},
\code{\link{sv_lte}()},
\code{\link{sv_lt}()},
\code{\link{sv_not_equal}()},
\code{\link{sv_numeric}()},
\code{\link{sv_regex}()},
\code{\link{sv_required}()},
\code{\link{sv_url}()}
}
\concept{rule functions}
