% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/notes.R
\name{notes}
\alias{notes}
\title{Additional or replacement notes}
\usage{
notes(sso, notes, replace = FALSE)
}
\arguments{
\item{sso}{shinystan object.}

\item{notes}{Optional. A character vector of additional or replacement notes.}

\item{replace}{If \code{TRUE} the existing notes are overwritten by
\code{notes} if \code{notes} is specified. If \code{FALSE} (the default)
if \code{notes} is specified then its content is appended to the existing
notes.}
}
\value{
If \code{notes} is missing then any existing notes stored in
  \code{sso} are returned as a character string. If \code{notes} is specified
  then an updated shinystan object is returned with either \code{notes} added
  to the previous notes (if \code{replace=FALSE}) or overwritten by
  \code{notes} (if \code{replace = TRUE}).
}
\description{
Notes are viewable on ShinyStan's Notepad page
}
\examples{
\dontrun{
sso <- notes(sso, "new note")
sso <- notes(sso, c("a different note", "another note"), replace = TRUE)

# See any notes currently in sso
notes(sso)
}
}
\seealso{
\code{\link{as.shinystan}}
}

