% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{formatCode}
\alias{formatCode}
\alias{styleText}
\alias{deparseCode}
\title{Deparse and format shinymeta expressions}
\usage{
formatCode(code, width = 500L, formatter = styleText, ...)

styleText(code, ...)

deparseCode(code, width = 500L)
}
\arguments{
\item{code}{Either an unevaluated expression or a deparsed code string.}

\item{width}{The \code{width.cutoff} to use when \code{\link[=deparse]{deparse()}}-ing the \code{code} expression.}

\item{formatter}{a function that accepts deparsed code (a character string)
as the first argument.}

\item{...}{arguments passed along to the \code{formatter} function.}
}
\value{
Single-element character vector with formatted code
}
\description{
Turn unevaluated shinymeta expressions into (formatted or styled) text.
}
\details{
Before any formatting takes place, the unevaluated expression is
deparsed into a string via \code{\link[=deparseCode]{deparseCode()}}, which ensures that
shinymeta comment strings (i.e., literal strings that appear on their own line,
and begin with one or more \verb{#} characters.) are turned into comments and
superfluous \verb{\\\{} are removed. After deparsing, the \code{formatCode()} function then
calls the \code{formatter} function on the deparsed string to format (aka style) the code string.
The default \code{formatter}, \code{styleText()}, uses \code{\link[styler:style_text]{styler::style_text()}} with a couple differences:
\itemize{
\item Pipe operators (\verb{\%>\%}) are \emph{always} followed by a line break.
\item If the token appearing after a line-break is a comma/operator, the line-break is removed.
}
}
\examples{

options(shiny.suppressMissingContextError = TRUE)

x <- metaReactive({
  "# Here's a comment"
  sample(5) \%>\% sum()
})

code <- expandChain(x())

deparseCode(code)
formatCode(code)
formatCode(code, formatter = styler::style_text)
}
