% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsFunc-runjs.R
\name{runjs}
\alias{runjs}
\title{Run JavaScript code}
\usage{
runjs(code)
}
\arguments{
\item{code}{JavaScript code to run.}
}
\description{
Run arbitrary JavaScript code.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      useShinyjs(),  # Set up shinyjs
      actionButton("btn", "Click me")
    ),
    server = function(input, output) {
      observeEvent(input$btn, {
        # Run JS code that simply shows a message
        runjs("var today = new Date(); alert(today);")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{useShinyjs}}
}
