% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\alias{report_success}
\alias{report_failure}
\alias{report_info}
\alias{report_warning}
\title{Reports}
\usage{
report(
  title,
  text,
  ...,
  button = "Ok",
  type = c("success", "failure", "info", "warning"),
  session = shiny::getDefaultReactiveDomain()
)

report_success(title, text, ..., button = "Ok")

report_failure(title, text, ..., button = "Ok")

report_info(title, text, ..., button = "Ok")

report_warning(title, text, ..., button = "Ok")
}
\arguments{
\item{title}{Title of the report.}

\item{text}{Text to be displayed.}

\item{...}{Options passed to JavaScript method, see \code{\link[=config_report]{config_report()}}.}

\item{button}{Label for the button.}

\item{type}{Type of notification: \code{success}, \code{failure}, \code{info} or \code{warning}.}

\item{session}{Default Shiny session.}
}
\value{
No value.
}
\description{
show extended notifications that contain a title, description to the user.
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(
  tags$h2("Report examples"),
  tags$p(
    "More examples available on the official website:",
    tags$a("https://notiflix.github.io/report")
  ),
  actionButton("success", "Success"),
  actionButton("failure", "Failure"),
  actionButton("info", "Info"),
  actionButton("warning", "Warning")
)

server <- function(input, output, session) {

  observeEvent(input$success, {
    report_success(
      "Well done!",
      "All in order"
    )
  })

  observeEvent(input$failure, {
    report_failure(
      "Oups...",
      "Something went wrong"
    )
  })

  observeEvent(input$info, {
    report_info(
      "For your information",
      tags$p(
        style = "font-style: italic;",
        "Lorem ipsum dolor sit amet"
      )
    )
  })

  observeEvent(input$warning, {
    report_warning(
      "Be careful!",
      "There were 30 warnings (use warnings() to see them)"
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
\references{
Report module from \href{https://github.com/notiflix/Notiflix}{Notiflix} library.
More documentation and examples are available on the official website:
\url{https://notiflix.github.io/report}.
}
