% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-pretty.R
\name{prettySwitch}
\alias{prettySwitch}
\title{Pretty Switch Input}
\usage{
prettySwitch(
  inputId,
  label,
  value = FALSE,
  status = "default",
  slim = FALSE,
  fill = FALSE,
  bigger = FALSE,
  inline = FALSE,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value (\code{TRUE} or \code{FALSE}).}

\item{status}{Add a class to the switch, you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.}

\item{slim}{Change the style of the switch (\code{TRUE} or \code{FALSE}), see examples.}

\item{fill}{Change the style of the switch (\code{TRUE} or \code{FALSE}), see examples.}

\item{bigger}{Scale the switch a bit bigger (\code{TRUE} or \code{FALSE}).}

\item{inline}{Display the input inline, if you want to place switch next to each other.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}
}
\value{
\code{TRUE} or \code{FALSE} server-side.
}
\description{
A toggle switch to replace checkbox
}
\note{
Appearance is better in a browser such as Chrome than in RStudio Viewer
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h1("Pretty switches"),
  br(),

  fluidRow(
    column(
      width = 4,
      prettySwitch(inputId = "switch1", label = "Default:"),
      verbatimTextOutput(outputId = "res1"),
      br(),
      prettySwitch(
        inputId = "switch4",
        label = "Fill switch with status:",
        fill = TRUE, status = "primary"
      ),
      verbatimTextOutput(outputId = "res4")
    ),
    column(
      width = 4,
      prettySwitch(
        inputId = "switch2",
        label = "Danger status:",
        status = "danger"
      ),
      verbatimTextOutput(outputId = "res2")
    ),
    column(
      width = 4,
      prettySwitch(
        inputId = "switch3",
        label = "Slim switch:",
        slim = TRUE
      ),
      verbatimTextOutput(outputId = "res3")
    )
  )

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$switch1)
  output$res2 <- renderPrint(input$switch2)
  output$res3 <- renderPrint(input$switch3)
  output$res4 <- renderPrint(input$switch4)

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
See \code{\link{updatePrettySwitch}} to update the value server-side.
}
