% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-awesomecheckbox.R
\name{awesomeCheckbox}
\alias{awesomeCheckbox}
\title{Awesome Checkbox Input Control}
\usage{
awesomeCheckbox(
  inputId,
  label,
  value = FALSE,
  status = "primary",
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Input label.}

\item{value}{Initial value (TRUE or FALSE).}

\item{status}{Color of the buttons, a valid Bootstrap status : default, primary, info, success, warning, danger.}

\item{width}{The width of the input}
}
\value{
A checkbox control that can be added to a UI definition.
}
\description{
Create a Font Awesome Bootstrap checkbox that can be used to specify logical values.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
 awesomeCheckbox(inputId = "somevalue",
                 label = "A single checkbox",
                 value = TRUE,
                 status = "danger"),
 verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$somevalue })
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link{updateAwesomeCheckbox}}
}
