% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical-tab.R
\name{vertical-tab}
\alias{vertical-tab}
\alias{verticalTabsetPanel}
\alias{verticalTabPanel}
\title{Vertical tab panel}
\usage{
verticalTabsetPanel(..., selected = NULL, id = NULL,
  color = "#112446", contentWidth = 9, menuSide = "left")

verticalTabPanel(title, ..., value = title, icon = NULL,
  box_height = "160px")
}
\arguments{
\item{...}{For \code{verticalTabsetPanel}, \code{verticalTabPanel}
to include, and for the later, UI elements.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first tab will be selected.}

\item{id}{If provided, you can use \code{input$id} in your server logic to determine which of
the current tabs is active. The value will correspond to the \code{value} argument that is passed to \code{verticalTabPanel}.}

\item{color}{Color for the tab panels.}

\item{contentWidth}{Width of the content panel (must be between 1 and 12), menu width will be \code{12 - contentWidth}.}

\item{menuSide}{Side for the menu: right or left.}

\item{title}{Display title for tab.}

\item{value}{Not used yet.}

\item{icon}{Optional icon to appear on the tab.}

\item{box_height}{Height for the title box.}
}
\description{
Vertical tab panel
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  fluidRow(
    column(
      width = 10, offset = 1,
      tags$h2("Vertical tab panel example"),
      verticalTabsetPanel(
        verticalTabPanel(
          title = "Title 1", icon = icon("home", "fa-2x"),
          "Content panel 1"
        ),
        verticalTabPanel(
          title = "Title 2", icon = icon("map", "fa-2x"),
          "Content panel 2"
        ),
        verticalTabPanel(
          title = "Title 3", icon = icon("rocket", "fa-2x"),
          "Content panel 3"
        )
      )
    )
  )
)

server <- function(input, output, session) {

}

shinyApp(ui, server)

}

}
}
\seealso{
\code{\link{updateVerticalTabsetPanel}} for updating selected tabs.
}
