% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{sendSweetAlert}
\alias{sendSweetAlert}
\title{Display a Sweet Alert to the user}
\usage{
sendSweetAlert(session, title = "Title", text = NULL, type = NULL,
  btn_labels = "Ok", html = FALSE, closeOnClickOutside = TRUE)
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{title}{Title of the alert.}

\item{text}{Text of the alert.}

\item{type}{Type of the alert : info, success, warning or error.}

\item{btn_labels}{Label(s) for button(s), can be of length 2,
in which case the alert will have two buttons.}

\item{html}{Does \code{text} contains HTML tags ?}

\item{closeOnClickOutside}{Decide whether the user should be able to dismiss
the modal by clicking outside of it, or not.}
}
\description{
Send a message from the server and launch a sweet alert in the UI.
}
\examples{
\dontrun{
if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Sweet Alert examples"),
  actionButton(
    inputId = "success",
    label = "Launch a success sweet alert",
    icon = icon("check")
  ),
  actionButton(
    inputId = "error",
    label = "Launch an error sweet alert",
    icon = icon("remove")
  ),
  actionButton(
    inputId = "sw_html",
    label = "Sweet alert with HTML",
    icon = icon("thumbs-up")
  )
)

server <- function(input, output, session) {

  observeEvent(input$success, {
    sendSweetAlert(
      session = session,
      title = "Success !!",
      text = "All in order",
      type = "success"
    )
  })

  observeEvent(input$error, {
    sendSweetAlert(
      session = session,
      title = "Error !!",
      text = "It's broken...",
      type = "error"
    )
  })

  observeEvent(input$sw_html, {
    sendSweetAlert(
      session = session,
      title = NULL,
      text = tags$span(
        tags$h3("With HTML tags",
                style = "color: steelblue;"),
        "In", tags$b("bold"), "and", tags$em("italic"),
        tags$br(),
        "and",
        tags$br(),
        "line",
        tags$br(),
        "breaks",
        tags$br(),
        "and an icon", icon("thumbs-up")
      ),
      html = TRUE
    )
  })

}

shinyApp(ui, server)


# output in Sweet Alert #

library("shiny")
library("shinyWidgets")

shinyApp(
  ui = fluidPage(
    tags$h1("Click the button"),
    actionButton(
      inputId = "sw_html",
      label = "Sweet alert with plot"
    ),
    # SweetAlert width
    tags$style(".swal-modal {width: 80\%;}")
  ),
  server = function(input, output, session) {
    observeEvent(input$sw_html, {
      sendSweetAlert(
        session = session,
        title = "Yay a plot!",
        text = tags$div(
          plotOutput(outputId = "plot"),
          sliderInput(
            inputId = "clusters",
            label = "Number of clusters",
            min = 2, max = 6, value = 3, width = "100\%"
          )
        ),
        html = TRUE
      )
    })
    output$plot <- renderPlot({
      plot(Sepal.Width ~ Sepal.Length,
           data = iris, col = Species,
           pch = 20, cex = 2)
      points(kmeans(iris[, 1:2], input$clusters)$centers,
             pch = 4, cex = 4, lwd = 4)
    })
  }
)

}
}
}
\seealso{
\code{\link{confirmSweetAlert}}, \code{\link{inputSweetAlert}}
}
