% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-multi.R
\name{multiInput}
\alias{multiInput}
\title{Create a multiselect input control}
\usage{
multiInput(inputId, label, choices = NULL, selected = NULL,
  options = NULL, width = NULL, choiceNames = NULL, choiceValues = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from.}

\item{selected}{The initially selected value}

\item{options}{List of options passed to multi (\code{enable_search = FALSE} for disabling the search bar for example)}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}}

\item{choiceNames}{List of names to display}

\item{choiceValues}{List of value to retrieve in server}
}
\value{
A multiselect control
}
\description{
A user-friendly replacement for select boxes with the multiple attribute
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {
library("shiny")
library("shinyWidgets")
ui <- fluidPage(
  multiInput(
    inputId = "id", label = "Fruits :",
    choices = c("Banana", "Blueberry", "Cherry", "Coconut", "Grapefruit",
                "Kiwi", "Lemon", "Lime", "Mango", "Orange", "Papaya"),
    selected = "Banana", width = "350px"
  ),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {
  output$res <- renderPrint({
    input$id
  })
}

shinyApp(ui = ui, server = server)
}
}
}
