% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Sheet.R
\name{updateF7Sheet}
\alias{updateF7Sheet}
\title{update a framework 7 sheet modal}
\usage{
updateF7Sheet(inputId, session)
}
\arguments{
\item{inputId}{Sheet id.}

\item{session}{Shiny session object}
}
\description{
update a framework 7 sheet modal
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
    ui = f7Page(
       color = "pink",
       title = "My app",
       f7SingleLayout(
          navbar = f7Navbar(title = "f7Sheet"),
          f7Button(inputId = "go", label = "Go"),
          f7Sheet(
             id = "sheet1",
             label = "More",
             orientation = "bottom",
             swipeToClose = TRUE,
             swipeToStep = TRUE,
             backdrop = TRUE,
             "Lorem ipsum dolor sit amet, consectetur adipiscing elit.
         Quisque ac diam ac quam euismod porta vel a nunc. Quisque sodales
         scelerisque est, at porta justo cursus ac"
          )
       )
    ),
    server = function(input, output, session) {
       observe({print(input$sheet1)})
       observeEvent(input$go, {
          updateF7Sheet(inputId = "sheet1", session = session)
       })
    }
 )
}
}
