% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_nmx.r
\name{run_nmx}
\alias{run_nmx}
\title{Runs a nlmixr model}
\usage{
run_nmx(
  mod,
  proj = proj,
  ext = TRUE,
  saverds = TRUE,
  autoupdate = TRUE,
  projloc = ".",
  addcwres = TRUE,
  addnpde = TRUE
)
}
\arguments{
\item{mod}{character with the model file present in project object}

\item{proj}{project object}

\item{ext}{logical indicating if the model should be run external in a separate r session}

\item{saverds}{logical indicating if the model results should be saved in a rds file}

\item{autoupdate}{logical indicating if the project object should automatically update}

\item{projloc}{character with the base location of the shinyMixR project}

\item{addcwres}{logical indicating if CWRES should be added to the output}

\item{addnpde}{logical indicating if NPDE should be added to the output}
}
\value{
In case the model is not submitted in a separate R session, the results from nlmixr are returned otherwise
  the result of the system call will be returned
}
\description{
Runs an nlmixr model from a project object with the possibility to run in an
external rsession using a system call (tested within linux only)
}
\details{
the meta data is obtained by compiling the model. The dataset, estimation method and control list are
  then included in the nlmixr call. Meta data is included in the model function which is comparable with NONMEM.
  This method was chosen so that all information to run a model is kept together in one function
}
\examples{

\dontrun{
 run_nmx("run1",proj)
}
}
\author{
Richard Hooijmaijers
}
