% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixInput.R
\name{matrixInput}
\alias{matrixInput}
\title{Create a matrix input field}
\usage{
matrixInput(
  inputId,
  label = NULL,
  value = matrix("", 1, 1),
  inputClass = "",
  rows = list(),
  cols = list(),
  class = "character",
  paste = FALSE,
  copy = FALSE,
  copyDoubleClick = FALSE,
  pagination = FALSE,
  lazy = FALSE
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value}

\item{label}{label for input field}

\item{value}{Initial value. Should be a matrix}

\item{inputClass}{class of the matrix input html element}

\item{rows}{list of options to configure rows}

\item{cols}{list of options to configure cols}

\item{class}{Matrix will be coerced to a matrix of this class. `character` and `numeric`
are supported}

\item{paste}{old argument}

\item{copy}{old argument}

\item{copyDoubleClick}{old argument}

\item{pagination}{Use pagination to display matrix}

\item{lazy}{lazy updating of server values. The new values are only sent to the server when no input field is visible}
}
\description{
Use this function to create a matrix input field. Typically this would be in the `ui.R` file
of your shiny application. You can access the input via the `input$inputId` in the server
function of the shiny application. The value will always be a matrix and contain values of
class `class`.
}
\details{
The parameters `rows` and `cols` take a list of arguments. Currently, the following arguments
are supported:

\describe{
  \item{n}{number of rows (is calculated from value as default)}
  \item{names}{should row/colnames be displayed? The names are taken from value}
  \item{editableNames}{should row/colnames be editable}
  \item{extend}{Should the matrix be extended if data is entered in the last row/column?}
  \item{delta}{how many blank rows/cols should be added?}
  \item{createHeader, updateHeader}{name of javascript function to override
default function to create/update table header. The function needs to
have the table element and the data object as argument}
  \item{getHeader}{same as createHeader but with table element as only argument}
}
}
\examples{
matrixInput(
  "myMatrix",
  value = diag(3),
  rows = list(names = FALSE),
  cols = list(names = FALSE)
)

}
