% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraModal.R
\name{chakraModal}
\alias{chakraModal}
\title{Modal widget}
\usage{
chakraModal(
  inputId,
  options = chakraModalOptions(),
  openButton,
  isOpen = FALSE,
  header,
  body,
  footer
)
}
\arguments{
\item{inputId}{widget id}

\item{options}{named list of options created with
\code{\link{chakraModalOptions}}}

\item{openButton}{a Chakra button to open the modal}

\item{isOpen}{whether the modal is initially open}

\item{header}{a \code{ModalHeader} element}

\item{body}{a \code{ModalBody} element}

\item{footer}{a \code{ModalFooter} element; usually it contains
some Chakra buttons (that you can group with \code{Tag$ButtonGroup(...)})}
}
\value{
A widget that can be used in \code{\link{chakraComponent}}.
}
\description{
A modal widget.
}
\details{
You can use an \code{action} attribute and a \code{value}
  attribute to the Chakra buttons you put in the widget. For example, if
  you include the Chakra button
  \code{Tag$Button("Close", action = "close", value = "CLOSE")}, clicking
  this button will close the modal and will set the Shiny value
  \code{"CLOSE"}. Other possible action attributes are \code{"cancel"} to
  cancel, \code{"disable"} to disable the modal, and
  \code{"remove"} to entirely remove the modal.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    chakraModal(
      inputId = "modal",
      openButton = Tag$Button(
        colorScheme = "orange",
        "Open Modal"
      ),
      header = Tag$ModalHeader(
        fontSize = "lg",
        fontWeight = "bold",
        "Modal title"
      ),
      body = Tag$ModalBody(
        "Sit nulla est ex deserunt exercitation anim occaecat."
      ),
      footer = Tag$ModalFooter(
        Tag$ButtonGroup(
          spacing = "3",
          Tag$Button(
            action = "close",
            value = "CLOSE",
            "Close"
          ),
          Tag$Button(
            action = "cancel",
            colorScheme = "red",
            "Cancel"
          )
        )
      )
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["modal"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
