% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraCheckboxWithChildren.R
\name{chakraCheckboxWithChildren}
\alias{chakraCheckboxWithChildren}
\title{Checkbox with child checkboxes}
\usage{
chakraCheckboxWithChildren(
  inputId,
  parentCheckbox,
  ...,
  stackAttributes = list(pl = 6, mt = 1, spacing = 1)
)
}
\arguments{
\item{inputId}{widget id}

\item{parentCheckbox}{the parent checkbox}

\item{...}{the child checkboxes}

\item{stackAttributes}{list of attributes which control the layout}
}
\value{
A widget to use in \code{\link{chakraComponent}}.
}
\description{
A widget with a parent checkbox and child checkboxes.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    chakraCheckboxWithChildren(
      "cwc",
      Tag$Checkbox(
        "Parent checkbox"
      ),
      Tag$Checkbox(
        "Child checkbox 1"
      ),
      Tag$Checkbox(
        defaultChecked = TRUE,
        "Child checkbox 2"
      )
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["cwc"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
