% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ace-autocomplete.R
\name{aceAutocomplete}
\alias{aceAutocomplete}
\title{Enable Code Completion for an Ace Code Input}
\usage{
aceAutocomplete(inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The id of the input object}

\item{session}{The \code{session} object passed to function given to shinyServer}
}
\value{
An observer reference class object that is responsible for offering code completion.
See \code{\link[shiny]{observe}} for more details. You can use \code{suspend} or \code{destroy}
to pause to stop dynamic code completion.
}
\description{
This function dynamically auto complete R code pieces using built-in function
\code{utils:::.win32consoleCompletion}. Please see \code{\link[utils]{rcompgen}} for details.
}
\details{
You can implement your own code completer by listening to \code{input$shinyAce_<editorId>_hint}
where <editorId> is the \code{aceEditor} id. The input contains
\itemize{
 \item \code{linebuffer}: Code/Text at current editing line
 \item \code{cursorPosition}: Current cursor position at this line
}
}

