% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{callModule}
\alias{callModule}
\title{Invoke a Shiny module}
\usage{
callModule(module, id, ..., session = getDefaultReactiveDomain())
}
\arguments{
\item{module}{A Shiny module server function}

\item{id}{An ID string that corresponds with the ID used to call the module's
UI function}

\item{...}{Additional parameters to pass to module server function}

\item{session}{Session from which to make a child scope (the default should
almost always be used)}
}
\value{
The return value, if any, from executing the module server function
}
\description{
Note: As of Shiny 1.5.0, we recommend using \code{\link[=moduleServer]{moduleServer()}} instead of
\code{\link[=callModule]{callModule()}}, because the syntax is a little easier
to understand, and modules created with \code{moduleServer} can be tested with
\code{\link[=testServer]{testServer()}}.
}
