% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap-layout.R
\name{fixedPage}
\alias{fixedPage}
\alias{fixedRow}
\title{Create a page with a fixed layout}
\usage{
fixedPage(..., title = NULL, theme = NULL, lang = NULL)

fixedRow(...)
}
\arguments{
\item{...}{Elements to include within the container}

\item{title}{The browser window title (defaults to the host URL of the page)}

\item{theme}{One of the following:
\itemize{
\item \code{NULL} (the default), which implies a "stock" build of Bootstrap 3.
\item A \code{\link[bslib:bs_theme]{bslib::bs_theme()}} object. This can be used to replace a stock
build of Bootstrap 3 with a customized version of Bootstrap 3 or higher.
\item A character string pointing to an alternative Bootstrap stylesheet
(normally a css file within the www directory, e.g. \code{www/bootstrap.css}).
}}

\item{lang}{ISO 639-1 language code for the HTML page, such as "en" or "ko".
This will be used as the lang in the \code{<html>} tag, as in \code{<html lang="en">}.
The default (NULL) results in an empty string.}
}
\value{
A UI defintion that can be passed to the \link{shinyUI} function.
}
\description{
Functions for creating fixed page layouts. A fixed page layout consists of
rows which in turn include columns. Rows exist for the purpose of making sure
their elements appear on the same line (if the browser has adequate width).
Columns exist for the purpose of defining how much horizontal space within a
12-unit wide grid it's elements should occupy. Fixed pages limit their width
to 940 pixels on a typical display, and 724px or 1170px on smaller and larger
displays respectively.
}
\details{
To create a fixed page use the \code{fixedPage} function and include
instances of \code{fixedRow} and \code{\link[=column]{column()}} within it. Note that
unlike \code{\link[=fluidPage]{fluidPage()}}, fixed pages cannot make use of higher-level
layout functions like \code{sidebarLayout}, rather, all layout must be done
with \code{fixedRow} and \code{column}.
}
\note{
See the \href{https://shiny.rstudio.com/articles/layout-guide.html}{ Shiny Application Layout Guide} for additional details on laying out fixed
pages.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fixedPage(
  title = "Hello, Shiny!",
  fixedRow(
    column(width = 4,
      "4"
    ),
    column(width = 3, offset = 2,
      "3 offset 2"
    )
  )
)

shinyApp(ui, server = function(input, output) { })
}

}
\seealso{
\code{\link[=column]{column()}}

Other layout functions: 
\code{\link{fillPage}()},
\code{\link{flowLayout}()},
\code{\link{fluidPage}()},
\code{\link{navbarPage}()},
\code{\link{sidebarLayout}()},
\code{\link{splitLayout}()},
\code{\link{verticalLayout}()}
}
\concept{layout functions}
