% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown.R
\name{updateSelectInput}
\alias{updateSelectInput}
\title{Change the value of a select input on the client}
\usage{
updateSelectInput(
  session,
  inputId,
  label = NULL,
  choices = NULL,
  selected = NULL
)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{choices}{List of values to select from. If elements of the list are named,
then that name — rather than the value — is displayed to the user.}

\item{selected}{The initially selected value (or multiple values if multiple = TRUE).
If not specified then defaults to the first value for single-select lists and no
values for multiple select lists.}
}
\description{
Update selecInput widget
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  ui <- semanticPage(
    p("The checkbox group controls the select input"),
    multiple_checkbox("checkboxes", "Input checkbox",
                      c("Item A", "Item B", "Item C")),
    selectInput("inSelect", "Select input",
                c("Item A", "Item B"))
  )

  server <- function(input, output, session) {
    observe({
      x <- input$checkboxes

      # Can use character(0) to remove all choices
      if (is.null(x))
        x <- character(0)

      # Can also set the label and select items
      updateSelectInput(session, "inSelect",
                        label = paste(input$checkboxes, collapse = ", "),
                        choices = x,
                        selected = tail(x, 1)
      )
    })
  }

  shinyApp(ui, server)
}

}
