% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider.R
\name{slider_input}
\alias{slider_input}
\alias{sliderInput}
\alias{range_input}
\title{Create Semantic UI Slider / Range}
\usage{
slider_input(input_id, value, min, max, step = 1, class = NULL)

sliderInput(inputId, label, min, max, value, step = 1, width = NULL, ...)

range_input(input_id, value, value2, min, max, step = 1, class = NULL)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under \code{input[[input_id]]}.}

\item{value}{The initial value to be selected for the sldier (lower value if using range).}

\item{min}{The minimum value allowed to be selected for the slider.}

\item{max}{The maximum value allowed to be selected for the slider.}

\item{step}{The interval between each selectable value of the slider.}

\item{class}{UI class of the slider. Can include \code{"Labeled"} and \code{"ticked"}.}

\item{inputId}{Input name.}

\item{label}{Display label for the control, or NULL for no label.}

\item{width}{character with width of slider.}

\item{...}{additional arguments}

\item{value2}{The initial upper value of the slider.}
}
\description{
This creates a slider input using Semantic UI. Slider is already initialized and
available under \code{input[[input_id]]}. Use Range for range of values.
}
\details{
Use \code{\link{update_slider}} to update the slider/range within the shiny session.
}
\examples{
if (interactive()) {

  library(shiny)
  library(shiny.semantic)

  # Slider example
  ui <- shinyUI(
    semanticPage(
      title = "Slider example",
      tags$br(),
      slider_input("slider", 10, 0, 20),
      p("Selected value:"),
      textOutput("slider")
    )
  )

   server <- shinyServer(function(input, output, session) {
     output$slider <- renderText(input$slider)
   })

   shinyApp(ui = ui, server = server)

   # Range example
   ui <- shinyUI(
     semanticPage(
       title = "Range example",
       tags$br(),
       range_input("range", 10, 15, 0, 20),
       p("Selected values:"),
       textOutput("range")
    )
  )

   server <- shinyServer(function(input, output, session) {
     output$range <- renderText(paste(input$range, collapse = " - "))
   })

   shinyApp(ui = ui, server = server)

 }

}
\seealso{
update_slider for input updates,
\url{https://fomantic-ui.com/modules/slider.html} for preset classes.
}
