% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkbox.R
\name{checkbox_input}
\alias{checkbox_input}
\alias{toggle}
\alias{This}
\alias{creates}
\alias{a}
\alias{checkbox}
\alias{using}
\alias{Semantic}
\alias{UI}
\alias{styles.}
\alias{checkboxInput}
\title{Create Semantic UI checkbox}
\usage{
checkbox_input(
  input_id,
  label = "",
  type = NULL,
  is_marked = TRUE,
  style = NULL
)

checkboxInput(inputId, label = "", value = FALSE, width = NULL)

toggle(input_id, label = "", is_marked = TRUE, style = NULL)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under input[[name]].}

\item{label}{Text to be displayed with checkbox.}

\item{type}{Type of checkbox: NULL, 'toggle'}

\item{is_marked}{Defines if checkbox should be marked. Default TRUE.}

\item{style}{Style of the widget.}

\item{inputId}{same as \code{input_id}}

\item{value}{same as \code{is_marked}}

\item{width}{The width of the input (currently not supported, but check \code{style})}
}
\description{
Create Semantic UI checkbox
}
\details{
The inputs are updateable by using \code{\link[shiny]{updateCheckboxInput}}.

The following \code{type}s are allowed:
\itemize{
\item{NULL}{ The standard checkbox (default)}
\item{toggle}{ Each checkbox has a toggle form}
\item{slider}{ Each checkbox has a simple slider form}
}
}
\examples{
if (interactive()){
  ui <- shinyUI(
    semanticPage(
      p("Simple checkbox:"),
      checkbox_input("example", "Check me", is_marked = FALSE),
      p(),
      p("Simple toggle:"),
      toggle("tog1", "My Label", TRUE)
    )
  )
  server <- function(input, output, session) {
    observeEvent(input$tog1, {
      print(input$tog1)
    })
  }
  shinyApp(ui, server)
}
}
