% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Nav}
\alias{Nav}
\title{Nav}
\usage{
Nav(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Navs (also called "left nav" or "navigation pane") provide links to the main areas of an app or a site. In larger configurations, the Nav is always on-screen, usually on the left of the view. In smaller configurations, the Nav may collapse into a skinnier version or be completely hidden until the user taps an icon.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Nav}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ link }} {\code{INavLink} \cr (Optional) Link to be rendered.}
\item {\bold{ ariaLabel }} {\code{string} \cr (Optional) The nav container aria label.}
\item {\bold{ className }} {\code{string} \cr Additional css class to apply to the Nav}
\item {\bold{ componentRef }} {\verb{IRefObject<INav>} \cr Optional callback to access the INav interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ expandButtonAriaLabel }} {\code{string} \cr (Optional) The nav container aria label. The link name is prepended to this label. If not provided, the aria label will default to the link name.}
\item {\bold{ groups }} {\code{INavLinkGroup[] | null} \cr A collection of link groups to display in the navigation bar}
\item {\bold{ initialSelectedKey }} {\code{string} \cr (Optional) The key of the nav item initially selected.}
\item {\bold{ isOnTop }} {\code{boolean} \cr Indicates whether the navigation component renders on top of other content in the UI}
\item {\bold{ linkAs }} {\verb{IComponentAs<INavButtonProps>} \cr Render a custom link in place of the normal one. This replaces the entire button rather than simply button content}
\item {\bold{ onLinkClick }} {\verb{(ev?: React.MouseEvent<HTMLElement>, item?: INavLink) => void} \cr Function callback invoked when a link in the navigation is clicked}
\item {\bold{ onLinkExpandClick }} {\verb{(ev?: React.MouseEvent<HTMLElement>, item?: INavLink) => void} \cr Function callback invoked when the chevron on a link is clicked}
\item {\bold{ onRenderGroupHeader }} {\verb{IRenderFunction<IRenderGroupHeaderProps>} \cr Used to customize how content inside the group header is rendered}
\item {\bold{ onRenderLink }} {\verb{IRenderFunction<INavLink>} \cr Used to customize how content inside the link tag is rendered}
\item {\bold{ selectedAriaLabel }} {\code{string} \cr (Deprecated) Use ariaCurrent on links instead}
\item {\bold{ selectedKey }} {\code{string} \cr (Optional) The key of the nav item selected by caller.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<INavStyleProps, INavStyles>} \cr Call to provide customized styling that will layer on top of the variant rules}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by HOC.}
}
}
\examples{
library(shiny.fluent)

if (interactive()) {
  navigation_styles <- list(
    root = list(
      height = "100\%",
      boxSizing = "border-box",
      border = "1px solid #eee",
      overflowY = "auto"
    )
  )

  link_groups <- list(
    list(
      links = list(
        list(
          name = "Home",
          expandAriaLabel = "Expand Home section",
          collapseAriaLabel = "Collapse Home section",
          links = list(
            list(
              name = "Activity",
              url = "http://msn.com",
              key = "key1",
              target = "_blank"
            ),
            list(
              name = "MSN",
              url = "http://msn.com",
              disabled = TRUE,
              key = "key2",
              target = "_blank"
            )
          ),
          isExpanded = TRUE
        ),
        list(
          name = "Documents",
          url = "http://example.com",
          key = "key3",
          isExpanded = TRUE
        ),
        list(
          name = "Pages",
          url = "http://msn.com",
          key = "key4"
        ),
        list(
          name = "Notebook",
          url = "http://msn.com",
          key = "key5",
          disabled = TRUE
        ),
        list(
          name = "Communication and Media",
          url = "http://msn.com",
          key = "key6"
        ),
        list(
          name = "News",
          url = "http://cnn.com",
          icon = "News",
          key = "key7",
          target = "_blank",
          iconProps = list(
            iconName = "News",
            styles = list(
              root = list(
                fontSize = 20,
                color = "#106ebe"
              )
            )
          )
        )
      )
    )
  )

  shinyApp(
    ui = Nav(
      groups = link_groups,
      selectedKey = "key1",
      styles = navigation_styles
    ),
    server = function(input, output) {}
  )
}
}
