% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{FontIcon}
\alias{FontIcon}
\alias{Icon}
\alias{ImageIcon}
\title{Icon}
\usage{
FontIcon(...)

Icon(...)

ImageIcon(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
In a user interface, an icon is an image that represents an application, a capability, or some other concept or specific entity with meaning for the user. An icon is usually selectable but can also be a nonselectable image, such as a company's logo.

For a list of icons, visit our \href{#/styles/web/icons}{icon documentation}.

Note that icons are not bundled by default and typically must be loaded by calling \code{initializeIcons} from the \verb{@uifabric/icons} package at the root of your application. See the \href{#/styles/web/icons#fabric-react}{icon documentation} for more details.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Icon}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ className }} {\code{string} \cr Custom class to style the icon.}
\item {\bold{ iconName }} {\code{string} \cr The name of the icon to use from the icon font. If string is empty, a placeholder icon will be rendered the same width as an icon.}
\item {\bold{ ariaLabel }} {\code{string} \cr The aria label of the icon for the benefit of screen readers.}
\item {\bold{ iconName }} {\code{string} \cr The name of the icon to use from the icon font. If string is empty, a placeholder icon will be rendered the same width as an icon.}
\item {\bold{ iconType }} {\code{IconType} \cr The type of icon to render (image or icon font).}
\item {\bold{ imageErrorAs }} {\verb{React.ComponentType<IImageProps>} \cr If rendering an image icon, this component will be rendered in the event that loading the image fails.}
\item {\bold{ imageProps }} {\code{IImageProps} \cr If rendering an image icon, these props will be passed to the Image component.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IIconStyleProps, IIconStyles>} \cr Gets the styles for an Icon.}
\item {\bold{ theme }} {\code{ITheme} \cr }
\item {\bold{ className }} {\code{string} \cr Custom class to style the icon.}
\item {\bold{ imageProps }} {\code{IImageProps} \cr Props passed to the Image component.}
}
}
\examples{
library(shiny.fluent)

if (interactive()) {
  style <- list(fontSize = 50, margin = 10)
  shinyApp(
    ui = tags$div(
      FontIcon(iconName = "CompassNW", style = style),
      FontIcon(iconName = "Dictionary", style = style),
      FontIcon(iconName = "TrainSolid", style = style)
    ),
    server = function(input, output) {}
  )
}
}
