% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{CommandBar}
\alias{CommandBar}
\title{CommandBar}
\usage{
CommandBar(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
CommandBar is a surface that houses commands that operate on the content of
the window, panel, or parent region it resides above. CommandBars are one of the most
visible and recognizable ways to surface commands, and can be an intuitive
method for interacting with content on the page; however, if overloaded or
poorly organized, they can be difficult to use and hide valuable commands from
your user. CommandBars can also display a search box for finding content, hold
simple commands as well as menus, or display the status of ongoing actions.

Commands should be sorted in order of importance, from left-to-right or right-to-left
depending on the culture. Secondarily, organize commands in logical
groupings for easier recall. CommandBars work best when they display no more
than 5-7 commands. This helps users quickly find your most valuable features.
If you need to show more commands, consider using the overflow menu. If you
need to render status or viewing controls, these go on the right side of the
CommandBar (or left side if in a left-to-right experience). Do not display
more than 2-3 items on the right side as it will make the overall CommandBar
difficult to parse.

All command items should have an icon and a label. Commands can render as
labels only as well. In smaller widths, commands can just use icon only, but
only for the most recognizable and frequently used commands. All other
commands should go into an overflow where text labels can be shown.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/CommandBar}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ buttonStyles }} {\code{IButtonStyles} \cr Custom styles for individual button}
\item {\bold{ cacheKey }} {\code{string} \cr A custom cache key to be used for this item. If \code{cacheKey} is changed, the cache will invalidate. Defaults to \code{key} value.}
\item {\bold{ commandBarButtonAs }} {\verb{IComponentAs<ICommandBarItemProps>} \cr Method to override the render of the individual command bar button. Not used when item is rendered in overflow.}
\item {\bold{ iconOnly }} {\code{boolean} \cr Show only an icon for this item, not text. Does not apply if item is in the overflow.}
\item {\bold{ renderedInOverflow }} {\code{boolean} \cr Context under which the item is being rendered. This value is mutated by the CommandBar and is useful for adjusting the \code{onRender} function.}
\item {\bold{ tooltipHostProps }} {\code{ITooltipHostProps} \cr Props for the tooltip when in \code{iconOnly} mode.}
\item {\bold{ ariaLabel }} {\code{string} \cr Accessibility text to be read by the screen reader when the user's focus enters the command bar. The screen reader will read this text after reading information about the first focusable item in the command bar.}
\item {\bold{ buttonAs }} {\verb{IComponentAs<IButtonProps>} \cr Custom component for the near and far item buttons. Not used for overflow menu items.}
\item {\bold{ className }} {\code{string} \cr Additional css class to apply to the command bar}
\item {\bold{ componentRef }} {\verb{IRefObject<ICommandBar>} \cr Optional callback to access the ICommandBar interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ dataDidRender }} {\verb{(renderedData: any) => void} \cr Function to be called every time data is rendered. It provides the data that was actually rendered. A use case would be adding telemetry when a particular control is shown in an overflow or dropped as a result of \code{onReduceData}, or to count the number of renders that an implementation of \code{onReduceData} triggers.}
\item {\bold{ farItems }} {\code{ICommandBarItemProps[]} \cr Items to render on the right side (or left, in RTL). ICommandBarItemProps extends IContextualMenuItem.}
\item {\bold{ items }} {\code{ICommandBarItemProps[]} \cr Items to render. ICommandBarItemProps extends IContextualMenuItem.}
\item {\bold{ onDataGrown }} {\verb{(movedItem: ICommandBarItemProps) => void} \cr Callback invoked when data has been grown.}
\item {\bold{ onDataReduced }} {\verb{(movedItem: ICommandBarItemProps) => void} \cr Callback invoked when data has been reduced.}
\item {\bold{ onGrowData }} {\verb{(data: ICommandBarData) => ICommandBarData | undefined} \cr Custom function to grow data if items are too small for the given space. Return \code{undefined} if no more steps can be taken to avoid infinate loop.}
\item {\bold{ onReduceData }} {\verb{(data: ICommandBarData) => ICommandBarData | undefined} \cr Custom function to reduce data if items do not fit in given space. Return \code{undefined} if no more steps can be taken to avoid infinate loop.}
\item {\bold{ overflowButtonAs }} {\verb{IComponentAs<IButtonProps>} \cr Custom component for the overflow button.}
\item {\bold{ overflowButtonProps }} {\code{IButtonProps} \cr Props to be passed to overflow button. If \code{menuProps} are passed through this prop, any items provided will be prepended to any computed overflow items.}
\item {\bold{ overflowItems }} {\code{ICommandBarItemProps[]} \cr Default items to have in the overflow menu. ICommandBarItemProps extends IContextualMenuItem.}
\item {\bold{ shiftOnReduce }} {\code{boolean} \cr When true, items will be 'shifted' off the front of the array when reduced, and unshifted during grow.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<ICommandBarStyleProps, ICommandBarStyles>} \cr Customized styling that will layer on top of the variant rules.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by HOC.}
}
}
\examples{
library(shiny.fluent)

if (interactive()) {
  items <- list(
    list(
      key = "newItem",
      text = "New",
      cacheKey = "myCacheKey",
      iconProps = list(iconName = "Add"),
      subMenuProps = list(
        items = list(
          list(
            key = "emailMessage",
            text = "Email message",
            iconProps = list(iconName = "Mail")
          ),
          list(
            key = "calendarEvent",
            text = "Calendar event",
            iconProps = list(iconName = "Calendar")
          )
        )
      )
    ),
    list(
      key = "upload",
      text = "Upload",
      iconProps = list(iconName = "Upload")
    ),
    list(
      key = "share",
      text = "Share",
      iconProps = list(iconName = "Share")
    ),
    list(
      key = "download",
      text = "Download",
      iconProps = list(iconName = "Download")
    )
  )

  farItems <- list(
    list(
      key = "tile",
      text = "Grid view",
      ariaLabel = "Grid view",
      iconOnly = TRUE,
      iconProps = list(iconName = "Tiles")
    ),
    list(
      key = "info",
      text = "Info",
      ariaLabel = "Info",
      iconOnly = TRUE,
      iconProps = list(iconName = "Info")
    )
  )

  shinyApp(
    ui = CommandBar(items = items, farItems = farItems),
    server = function(input, output) {}
  )
}
}
